/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.actions.Messages;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public class WatchAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate,
IViewActionDelegate {
    private ISelection fSelection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void init(IViewPart view) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        String expressionText;
        if (this.fSelection == null) {
            return;
        }
        if (this.fSelection instanceof IStructuredSelection) {
            for (Object object : ((IStructuredSelection)this.fSelection).toList()) {
                IVariable variable = (IVariable)object;
                try {
                    this.createExpression(variable.getName());
                }
                catch (DebugException e) {
                    DebugUiPlugin.errorDialog((String)Messages.WatchAction_CreateWatchExpressionFailed, (Throwable)e);
                }
            }
        } else if (this.fSelection instanceof ITextSelection && (expressionText = ((ITextSelection)this.fSelection).getText()).length() > 0) {
            this.createExpression(expressionText);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = null;
        if (!action.isEnabled()) {
            return;
        }
        int enabled = 0;
        int size = -1;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = selection;
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            size = sSelection.size();
            IExpressionManager manager = DebugPlugin.getDefault().getExpressionManager();
            for (IVariable variable : sSelection) {
                if (!manager.hasWatchExpressionDelegate(variable.getModelIdentifier())) break;
                ++enabled;
            }
            if (enabled != size) {
                action.setEnabled(false);
            }
        } else if (selection instanceof ITextSelection) {
            this.fSelection = selection;
            ITextSelection tSelection = (ITextSelection)selection;
            if (tSelection.getLength() == 0) {
                action.setEnabled(false);
            }
        }
    }

    protected void showExpressionsView() {
        IWorkbenchPage page = UIUtils.getActivePage();
        IViewPart part = page.findView("org.eclipse.debug.ui.ExpressionView");
        if (part == null) {
            try {
                page.showView("org.eclipse.debug.ui.ExpressionView");
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
            }
        } else {
            page.bringToTop((IWorkbenchPart)part);
        }
    }

    protected void createExpression(String expressionText) {
        IWatchExpression expression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(expressionText);
        DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)expression);
        IAdaptable object = DebugUITools.getDebugContext();
        IDebugElement context = null;
        if (object instanceof IDebugElement) {
            context = (IDebugElement)object;
        } else if (object instanceof ILaunch) {
            context = ((ILaunch)object).getDebugTarget();
        }
        expression.setExpressionContext(context);
        this.showExpressionsView();
    }
}

